//--------------------------------------------------------------
// Header
//
// Define : Name, Category, Subcategory, Notes, Flags
//--------------------------------------------------------------
DeclareLightworksEffect( "Channel Combiner", "Colour", "User", kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Inputs
//
// For each 'texture' declared here, Lightworks adds a matching
// input to your effect
//--------------------------------------------------------------
DeclareInputs( R, G, B, A );

//--------------------------------------------------------------
// Define parameters here.
//
// The Lightworks application will automatically generate
// sliders/controls for all parameters which do not start
// with a a leading '_' character
//--------------------------------------------------------------
DeclareFloatParam( Opacity, "Opacity", kNoGroup, kNoFlags, 1.0, 0.0, 1.0 );

//--------------------------------------------------------------
// Pixel Shader
//
// This section defines the code which the GPU will
// execute for every pixel in an output image.
//
// Note that pixels are processed out of order, in parallel.
//--------------------------------------------------------------
DeclareEntryPoint()
{
   return float4( tex2D( R, uv1 ).r,
                  tex2D( G, uv2 ).g,
                  tex2D( B, uv3 ).b,
                  tex2D( A, uv4 ).a * Opacity );
}
